//Capital Budgeting
//Payback Period - Project Selection
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Given
project_cost = 200000        //in rupees
projecta_cashinflow = [50000,50000,50000,50000,50000]     //in years 1-5
projectb_cashinflow = [100000,100000,100000,100000,100000]     //in years 1-5
rcA = 0      //recovering period for Project A
rcB = 0      //recovering period for Project B

//Solution
projecta_cumulative_cashinflow = [0,0,0,0,0]
projecta_cumulative_cashinflow(1) = projecta_cashinflow(1)             //since 1st value of cumulation is always 1st value of cashinflow
projectb_cumulative_cashinflow = [0,0,0,0,0]
projectb_cumulative_cashinflow(1) = projectb_cashinflow(1)             //since 1st value of cumulation is always 1st value of cashinflow
for i=2:5
    projecta_cumulative_cashinflow(i) = projecta_cumulative_cashinflow(i-1) + projecta_cashinflow(i)
    projectb_cumulative_cashinflow(i) = projectb_cumulative_cashinflow(i-1) + projectb_cashinflow(i)
end

//Result
mprintf("     Project A")
mprintf("\n Year  Cash inflow  Cumulative cash inflow")
for i=1:5
    mprintf("\n  %d       %d             %d",i,projecta_cashinflow(i),projecta_cumulative_cashinflow(i))
end

mprintf("\n\n     Project B")
mprintf("\n Year  Cash inflow  Cumulative cash inflow")
for i=1:5
    mprintf("\n  %d       %d             %d",i,projectb_cashinflow(i),projectb_cumulative_cashinflow(i))
end

for i=1:5
    if(projecta_cumulative_cashinflow(i) == project_cost)
        mprintf("\n\nRecovering period is %d years in Project A",i)
        rcA = i
    end
end

for i=1:5
    if(projectb_cumulative_cashinflow(i) == project_cost)
        mprintf("\nRecovering period is %d years in Project B",i)
        rcB = i
    end
end

if rcA < rcB then
    mprintf("Project A is accepted")
else
    mprintf("\nProject B is accepted")
end

//Output
//     Project A
// Year  Cash inflow  Cumulative cash inflow
//  1       50000             50000
//  2       50000             100000
//  3       50000             150000
//  4       50000             200000
//  5       50000             250000
//
//     Project B
// Year  Cash inflow  Cumulative cash inflow
//  1       100000             100000
//  2       100000             200000
//  3       100000             300000
//  4       100000             400000
//  5       100000             500000
//
//Recovering period is 4 years in Project A
//Recovering period is 2 years in Project B
//Project B is accepted
